﻿using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using System;
using VA.TMP.Integration.VIMT.Messages.Vista;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.ViaLogin
{
    public class CreateResponseStep : FilterBase<ViaLoginStateObject>
    {
        public override void Execute(ViaLoginStateObject state)
        {
            if (state.EcResponse == null) throw new Exception("No EC Response was returned");
            var failure = state.EcResponse.ExceptionOccured || state.EcResponse.VIMTVIAScheLIuserTOInfo?.VIMTVIAScheLIfault2Info != null;
            state.LoginResponse = new ViaLoginResponseMessage
            {
                ExceptionMessage = failure ? state.EcResponse?.ExceptionMessage ?? state.EcResponse.VIMTVIAScheLIuserTOInfo.VIMTVIAScheLIfault2Info.mcs_message : string.IsNullOrEmpty(state.FakeResponseType) ? "" : "*****THIS IS FAKE DATA. DATA NOT SENT TO Vista*****",
                ExceptionOccured = failure,
                SerializedInstance = state.SerializedInstance,
                UserDuz = failure ? null : state.EcResponse.VIMTVIAScheLIuserTOInfo.mcs_DUZ,
                EcProcessingMs = state.EcProcessingTimeMs
            };
            
        }
    }
}
